/*
 * SquareMazePrinter1.java
 *
 * Created on April 21, 2003, 12:44 PM
 * 
 * Copyright 2003 Danny Brewer
 * Anyone may run this code.
 * If you wish to modify or distribute this code, then
 *  you are granted a license to do so only under the terms
 *  of the Gnu Lesser General Public License.
 * See:  http://www.gnu.org/licenses/lgpl.html
 */

package nom.DannyBrewer.recreation.squareMaze;

/**
 *
 * @author  dbrewer
 */
public class SquareMazePrinter1 extends SquareMazePrinter {
	
    //----------------------------------------------------------------------
    //  Constructor
    //----------------------------------------------------------------------
	
	public SquareMazePrinter1( SquareMaze maze ) {
		super( maze );
	}

	
    //----------------------------------------------------------------------
    //  SquareMazePrinter implementation
    //----------------------------------------------------------------------
	
	// Print the wall that borders the top or bottom of a cell.
	protected void printHorizWall( boolean wall, boolean solution ) {
		if( wall ) {
			print( "---" );
		} else if( solution ) {
			print( " * " );
		} else {
			print( "   " );
		}
	}
	
	// Print the wall that borders the left or right of a cell.
	protected void printVertWall( boolean wall, boolean solution ) {
		if( wall ) {
			print( "|" );
		} else if( solution ) {
			print( "*" );
		} else {
			print( " " );
		}
	}
	
	// Print one character at the intersection of vertical and horizontal walls.
	// The four parameters indicate which parts of the cross should be printed.
	// The following implementation is for generic ASCII, but an implementation could
	//  be substituted that would use the line, box corner, T, upside down T, etc.
	//  characters of an IBM PC.
	protected void printCross( boolean top, boolean left, boolean bottom, boolean right ) {
		boolean vFlag = top  ||  bottom;
		boolean hFlag = left  ||  right;
		
		if( vFlag  &&  hFlag ) {
			print( "+" );
		} else if( vFlag ) {
			print( "|" );
		} else if( hFlag ) {
			print( "-" );
		} else {
			print( "+" );
		}
	}
	
	// Print the contents of a cell inside its walls.
	protected void printInnerCell( boolean solution ) {
		if( solution ) {
			print( " * " );
		} else {
			print( "   " );
		}
	}


    //----------------------------------------------------------------------
    //  Test routine
    //----------------------------------------------------------------------
	
	public static void main( String[] args ) {
		SquareMaze maze = new SquareMaze( 10, 15 );
		SquareMazeGenerator1 mazeGen = new SquareMazeGenerator1( maze );
		mazeGen.generateMaze();
		
		SquareMazePrinter mazePrinter = new SquareMazePrinter1( maze );
		mazePrinter.printMaze( true );
	}

} // class SquareMazePrinter1
